
def count_multiples_of_seven(limit):

    return limit // 7

def count_ending_in_seven(limit):

    positions = limit // 10
    return positions + 1 if limit % 10 >= 7 else positions

def count_with_both_properties(limit):

    numbers_with_last_digit_seven = count_ending_in_seven(limit)
    multiples_of_seven = count_multiples_of_seven(numbers_with_last_digit_seven)
    return multiples_of_seven

def count_total_special_numbers(limit):

    divisible_by_seven = count_multiples_of_seven(limit)
    ending_in_seven = count_ending_in_seven(limit)
    with_both_conditions = count_with_both_properties(limit)
    return divisible_by_seven + ending_in_seven - with_both_conditions

def locate_kth_special_number(k):

    lower_boundary = 1
    upper_boundary = 10**18
    while lower_boundary <= upper_boundary:
        midpoint = (lower_boundary + upper_boundary) // 2
        special_numbers_count = count_total_special_numbers(midpoint)
        if special_numbers_count >= k:
            upper_boundary = midpoint - 1
        else:
            lower_boundary = midpoint + 1
    return lower_boundary

import sys
input_data = sys.stdin.read()
data = input_data.strip()
target_position = int(data)

result = locate_kth_special_number(target_position)
print(result)












