﻿
program HamsterRooms;

type
  TRect = record
    x1, y1, x2, y2: integer;
  end;

var
  T, n, i, j: integer;
  rooms: array of TRect;

function check(a, b, c, d: real): boolean;
begin
  check := (abs(a * d - b * c) < 1e-9);
end;

function solve(): boolean;
var
  i, j, k, l: integer;
  x1, y1, x2, y2: integer;
  a, b, c, d: real;
begin
  for i := 0 to 7 do
    for j := i + 1 to 7 do
    begin
      x1 := 0;
      y1 := 0;
      x2 := 0;
      y2 := 0;

      case i of
        0: begin x1 := rooms[1].x1; y1 := rooms[1].y1; end;
        1: begin x1 := rooms[1].x1; y1 := rooms[1].y2; end;
        2: begin x1 := rooms[1].x2; y1 := rooms[1].y1; end;
        3: begin x1 := rooms[1].x2; y1 := rooms[1].y2; end;
        4: begin x1 := rooms[1].x1; y1 := rooms[n].y1; end;
        5: begin x1 := rooms[1].x1; y1 := rooms[n].y2; end;
        6: begin x1 := rooms[1].x2; y1 := rooms[n].y1; end;
        7: begin x1 := rooms[1].x2; y1 := rooms[n].y2; end;
      end;

      case j of
        0: begin x2 := rooms[1].x1; y2 := rooms[1].y1; end;
        1: begin x2 := rooms[1].x1; y2 := rooms[1].y2; end;
        2: begin x2 := rooms[1].x2; y2 := rooms[1].y1; end;
        3: begin x2 := rooms[1].x2; y2 := rooms[1].y2; end;
        4: begin x2 := rooms[1].x1; y2 := rooms[n].y1; end;
        5: begin x2 := rooms[1].x1; y2 := rooms[n].y2; end;
        6: begin x2 := rooms[1].x2; y2 := rooms[n].y1; end;
        7: begin x2 := rooms[1].x2; y2 := rooms[n].y2; end;
      end;

      a := y2 - y1;
      b := x1 - x2;
      c := - (a * x1 + b * y1);

      if (a = 0) and (b = 0) then continue;


      var ok : Boolean := True;
      for k := 1 to n do
      begin
        var count : integer := 0;
        var dist1 : real := Abs(a * rooms[k].x1 + b * rooms[k].y1 + c) / Sqrt(a * a + b * b);
        var dist2 : real := Abs(a * rooms[k].x1 + b * rooms[k].y2 + c) / Sqrt(a * a + b * b);
        var dist3 : real := Abs(a * rooms[k].x2 + b * rooms[k].y1 + c) / Sqrt(a * a + b * b);
        var dist4 : real := Abs(a * rooms[k].x2 + b * rooms[k].y2 + c) / Sqrt(a * a + b * b);

        if dist1 < 1e-9 then inc(count);
        if dist2 < 1e-9 then inc(count);
        if dist3 < 1e-9 then inc(count);
        if dist4 < 1e-9 then inc(count);

        if count = 0 then
        begin
          ok := False;
          Break;
        end;
      end;

      if ok then
      begin
        solve := true;
        exit;
      end;
    end;

  solve := false;
end;

begin
  ReadLn(T);
  for i := 1 to T do
  begin
    ReadLn(n);
    SetLength(rooms, n + 1);
    for j := 1 to n do
      ReadLn(rooms[j].x1, rooms[j].y1, rooms[j].x2, rooms[j].y2);

    if solve() then
      WriteLn('YES')
    else
      WriteLn('NO');
  end;
end.