﻿program LightLine;

type
  TRectangle = record
    x1, y1, x2, y2: Int64;
  end;

procedure SolveSet(n: Integer; rects: array of TRectangle);
var
  leftA, rightA, topA, bottomA: Int64;
  leftB, rightB, topB, bottomB: Int64;
  i: Integer;
  possible: Boolean;
begin
  leftA := -MaxInt64;
  rightA := MaxInt64;
  topA := -MaxInt64;
  bottomA := MaxInt64;
  
  for i := 0 to n - 1 do
  begin
    with rects[i] do
    begin
      if x1 > leftA then leftA := x1;
      if x2 < rightA then rightA := x2;
      if y1 > topA then topA := y1;
      if y2 < bottomA then bottomA := y2;
    end;
  end;
 
  if (leftA <= rightA) and (topA <= bottomA) then
    WriteLn('Yes')
  else
    WriteLn('No');
end;

var
  T, n, i: Integer;
  rects: array of TRectangle;
  x1, y1, x2, y2: Int64;
begin
  Read(T);
  for i := 1 to T do
  begin
    Read(n);
    SetLength(rects, n);
    for var j := 0 to n - 1 do
    begin
      Read(x1, y1, x2, y2);
      rects[j].x1 := x1; rects[j].y1 := y1;
      rects[j].x2 := x2; rects[j].y2 := y2;
    end;
    SolveSet(n, rects);
  end;
end.