﻿program MagicNumbers;

var
  k: Int64;

function countA(x: Int64): Int64;
begin
  Result := x div 7;
end;

function countB(x: Int64): Int64;
begin
  if x < 7 then
    Result := 0
  else
    Result := (x + 3) div 10;
end;

function countCommon(x: Int64): Int64;
begin
  if x < 7 then
    Result := 0
  else
    Result := ((x - 7) div 70) + 1;
end;

function countMagical(x: Int64): Int64;
begin
  Result := countA(x) + countB(x) - countCommon(x);
end;

var
  left, right, mid, res: Int64;
begin
  ReadLn(k);
  left := 1;
  right := 1000000000000000000;
  while left < right do
  begin
    mid := (left + right) shr 1;
    if countMagical(mid) >= k then
      right := mid
    else
      left := mid + 1;
  end;
  WriteLn(left);
end.