﻿program HamsterJustice;

type
  TRectangle = record
    x1, y1, x2, y2: int64;
  end;

function Solve: string;
var
  n, i: integer;
  rectangles: array of TRectangle;
  minA1, maxA2, minB1, maxB2: double;
  a1, a2, b1, b2: double;
begin
  readln(n);
  SetLength(rectangles, n);
  for i := 0 to n - 1 do
    readln(rectangles[i].x1, rectangles[i].y1, rectangles[i].x2, rectangles[i].y2);

  minA1 := -1e18;
  maxA2 := 1e18;
  minB1 := -1e18;
  maxB2 := 1e18;

  for i := 0 to n - 1 do
  begin
    a1 := rectangles[i].y1 - rectangles[i].x2;
    a2 := rectangles[i].y2 - rectangles[i].x1;
    b1 := rectangles[i].y1 + rectangles[i].x1;
    b2 := rectangles[i].y2 + rectangles[i].x2;

    minA1 := max(minA1, a1);
    maxA2 := min(maxA2, a2);
    minB1 := max(minB1, b1);
    maxB2 := min(maxB2, b2);
  end;

  if (minA1 <= maxA2) and (minB1 <= maxB2) then
    Solve := 'Yes'
  else
    Solve := 'No';
end;

var
  t, i: integer;
begin
  readln(t);
  for i := 1 to t do
    writeln(Solve);
end.
