import sys

maxr = 1000000

spf = [0] * (maxr + 1)
isodd_power = [False] * (maxr + 1)

def sieve_spf():
    primes = []

    for i in range(2, maxr + 1):
        if spf[i] == 0:
            spf[i] = i
            primes.append(i)

        for p in primes:
            if p > spf[i] or i * p > maxr:
                break
            spf[i * p] = p

def precomp():
    sieve_spf()

    for i in range(2, maxr + 1):
        tmp = i
        currentisop = True

        while tmp > 1:
            p = spf[tmp]
            count = 0

            while tmp > 1 and tmp % p == 0:
                count += 1
                tmp //= p

            if count % 2 == 0:
                currentisop = False
                break
            isodd_power[i] = currentisop

if __name__ == "__main__":
    precomp()

    m = int(sys.stdin.readline())
    l, r = map(int, sys.stdin.readline().split())

    consel = 0
    start = -1

    for i in range(l, r + 1):
        if isodd_power[i]:
            consel += 1
        else:
            consel = 1

        if consel == m:
            start = i - m + 1
            break

    if start != 1:
        print(*(start + i for i in range(m)))
    else:
        print(-1)

