def cross(o, a, b):
    return (a[0] - o[0]) * (b[1] - o[1]) - (a[1] - o[1]) * (b[0] - o[0])


def on_segment(p, q, r):
    if (min(p[0], r[0]) <= q[0] <= max(p[0], r[0]) and
            min(p[1], r[1]) <= q[1] <= max(p[1], r[1])):
        return cross(p, q, r) == 0
    return False


def line_intersects_rect(line_p1, line_p2, rect):
    x1, y1, x2, y2 = rect
    corners = [(x1, y1), (x2, y1), (x2, y2), (x1, y2)]

    for corner in corners:
        if cross(line_p1, line_p2, corner) == 0:
            return True
    sides = [
        (corners[0], corners[1]),
        (corners[1], corners[2]),
        (corners[2], corners[3]),
        (corners[3], corners[0])
    ]
    for side_p1, side_p2 in sides:
        d1 = cross(line_p1, line_p2, side_p1)
        d2 = cross(line_p1, line_p2, side_p2)
        d3 = cross(side_p1, side_p2, line_p1)
        d4 = cross(side_p1, side_p2, line_p2)
        if d1 * d2 < 0 and d3 * d4 < 0:
            return True
        if d1 == 0 and on_segment(line_p1, side_p1, line_p2):
            return True
        if d2 == 0 and on_segment(line_p1, side_p2, line_p2):
            return True
    return False


def can_cover_all_rects(rects):
    if len(rects) == 1:
        return True
    points = []
    for x1, y1, x2, y2 in rects:
        points.extend([(x1, y1), (x2, y1), (x2, y2), (x1, y2)])
    min_x = min(points, key=lambda p: p[0])
    max_x = max(points, key=lambda p: p[0])
    min_y = min(points, key=lambda p: p[1])
    max_y = max(points, key=lambda p: p[1])
    candidate_pairs = [
        (min_x, max_x), (min_y, max_y),
        (min_x, min_y), (min_x, max_y),
        (max_x, min_y), (max_x, max_y)
    ]
    for p1, p2 in candidate_pairs:
        if p1 == p2:
            continue
        if all(line_intersects_rect(p1, p2, rect) for rect in rects):
            return True
    return False


def main():
    import sys
    input_data = sys.stdin.read().strip().split()
    ptr = 0
    T = int(input_data[ptr])
    ptr += 1
    results = []
    for _ in range(T):
        n = int(input_data[ptr])
        ptr += 1
        rects = []
        for _ in range(n):
            x1 = int(input_data[ptr])
            y1 = int(input_data[ptr + 1])
            x2 = int(input_data[ptr + 2])
            y2 = int(input_data[ptr + 3])
            rects.append((x1, y1, x2, y2))
            ptr += 4
        results.append("Yes" if can_cover_all_rects(rects) else "No")
    print('\n'.join(results))


if __name__ == "__main__":
    main()
