def read_input():
    T = int(input().strip())
    tests = []
    for _ in range(T):
        n = int(input().strip())
        rooms = []
        for _ in range(n):
            x1, y1, x2, y2 = map(int, input().strip().split())
            rooms.append((x1, y1, x2, y2))
        tests.append(rooms)
    return tests


def get_corners(room):
    x1, y1, x2, y2 = room
    return [(x1, y1), (x1, y2), (x2, y1), (x2, y2)]


def line_through_points(p1, p2):
    x1, y1 = p1
    x2, y2 = p2
    A = y2 - y1
    B = x1 - x2
    C = x2 * y1 - x1 * y2
    return (A, B, C)


def point_on_line(p, line):
    A, B, C = line
    x, y = p
    return A * x + B * y + C == 0


def segment_intersects_line(seg, line):
    p1, p2 = seg
    x1, y1 = p1
    x2, y2 = p2
    A, B, C = line

    val1 = A * x1 + B * y1 + C
    val2 = A * x2 + B * y2 + C

    if val1 * val2 > 0:
        return False
    if val1 == 0 or val2 == 0:
        return True

    dx = x2 - x1
    dy = y2 - y1
    denom = A * dx + B * dy

    if denom == 0:
        return False

    t = -(A * x1 + B * y1 + C) / denom
    return 0 <= t <= 1


def rect_touched_by_line(rect, line):
    corners = get_corners(rect)
    for corner in corners:
        if point_on_line(corner, line):
            return True

    x1, y1, x2, y2 = rect
    sides = [
        ((x1, y1), (x1, y2)),
        ((x1, y2), (x2, y2)),
        ((x2, y2), (x2, y1)),
        ((x2, y1), (x1, y1))
    ]

    for side in sides:
        if segment_intersects_line(side, line):
            return True

    return False


def solve(rooms):
    n = len(rooms)
    if n <= 2:
        return "Yes"

    all_corners = []
    for room in rooms:
        all_corners.extend(get_corners(room))

    for i in range(len(all_corners)):
        for j in range(i + 1, len(all_corners)):
            p1 = all_corners[i]
            p2 = all_corners[j]
            if p1 == p2:
                continue
            line = line_through_points(p1, p2)

            if all(rect_touched_by_line(room, line) for room in rooms):
                return "Yes"

    return "No"


def main():
    tests = read_input()
    for rooms in tests:
        print(solve(rooms))


if __name__ == "__main__":
    main()
