def is_odd_power_number(n):
    """Проверяет, является ли число нечётно‑степенным."""
    if n == 1:
        return True

    d = 2
    while d * d <= n:
        if n % d == 0:
            cnt = 0
            while n % d == 0:
                cnt += 1
                n //= d
            if cnt % 2 == 0:
                return False
        d += 1

    return True


m = int(input())
l, r = map(int, input().split())

# Предварительно отмечаем нечётно‑степенные числа на [l, r]
size = r - l + 1
is_odd_power = [False] * size

for i in range(size):
    num = l + i
    is_odd_power[i] = is_odd_power_number(num)

# Ищем первую последовательность из m подряд идущих True
result = -1
for start in range(size - m + 1):
    if all(is_odd_power[start + j] for j in range(m)):
        result = ' '.join(str(l + start + j) for j in range(m))
        break

print(result)
