﻿#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

vector<int> sieve(int n) {
    vector<bool> is_prime(n + 1, true);
    is_prime[0] = is_prime[1] = false;
    for (int i = 2; i * i <= n; i++) {
        if (is_prime[i]) {
            for (int j = i * i; j <= n; j += i) {
                is_prime[j] = false;
            }
        }
    }
    vector<int> primes;
    for (int i = 2; i <= n; i++) {
        if (is_prime[i]) {
            primes.push_back(i);
        }
    }
    return primes;
}

bool is_odd_powered(long long x, const vector<int>& primes) {
    for (int p : primes) {
        if ((long long)p * p > x) break;
        if (x % p == 0) {
            int cnt = 0;
            while (x % p == 0) {
                x /= p;
                cnt++;
            }
            if (cnt % 2 == 0) {
                return false;
            }
        }
    }
    if (x > 1) {
        return true;
    }
    return true;
}

int main() {
    long long l, r;
    int m;
    cin >> l >> r >> m;

    int limit = sqrt(r) + 1;
    vector<int> primes = sieve(limit);

    vector<bool> is_odd_powered_seq(r - l + 1, false);

    for (long long x = l; x <= r; x++) {
        if (is_odd_powered(x, primes)) {
            is_odd_powered_seq[x - l] = true;
        }
    }

    int consecutive = 0;
    long long start = -1;
    for (long long i = l; i <= r; i++) {
        if (is_odd_powered_seq[i - l]) {
            consecutive++;
            if (consecutive == m) {
                start = i - m + 1;
                break;
            }
        }
        else {
            consecutive = 0;
        }
    }

    if (start != -1) {
        for (long long i = start; i < start + m; i++) {
            cout << i << " ";
        }
    }
    else {
        cout << -1;
    }

    return 0;
}