import sys
import math

def solve_e_full():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    
    idx = 0
    T = int(data[idx]); idx += 1
    results = []
    
    INF = 10**30
    
    def check_dir(a, b, rects):
        """Проверяем, существует ли прямая с нормалью (a,b)"""
        if a == 0 and b == 0:
            return False
        
        max_min_val = -INF
        min_max_val = INF
        
        for x1, y1, x2, y2 in rects:
            # Минимум и максимум a*x + b*y на прямоугольнике
            min_x_part = a * x1 if a >= 0 else a * x2
            max_x_part = a * x2 if a >= 0 else a * x1
            min_y_part = b * y1 if b >= 0 else b * y2
            max_y_part = b * y2 if b >= 0 else b * y1
            
            min_val = min_x_part + min_y_part
            max_val = max_x_part + max_y_part
            
            max_min_val = max(max_min_val, min_val)
            min_max_val = min(min_max_val, max_val)
            
            if max_min_val > min_max_val:
                return False
        
        return True
    
    for _ in range(T):
        n = int(data[idx]); idx += 1
        rects = []
        
        for i in range(n):
            x1 = int(data[idx]); idx += 1
            y1 = int(data[idx]); idx += 1
            x2 = int(data[idx]); idx += 1
            y2 = int(data[idx]); idx += 1
            rects.append((x1, y1, x2, y2))
        
        found = False
        
        # 1. Проверка вертикальных прямых
        left_max = max(r[0] for r in rects)
        right_min = min(r[2] for r in rects)
        if left_max <= right_min:
            found = True
        
        # 2. Проверка горизонтальных прямых
        if not found:
            bottom_max = max(r[1] for r in rects)
            top_min = min(r[3] for r in rects)
            if bottom_max <= top_min:
                found = True
        
        # 3. Проверка диагональных направлений 45° и 135°
        if not found:
            if check_dir(1, -1, rects):  # 45°
                found = True
            elif check_dir(1, 1, rects):  # 135°
                found = True
        
        # 4. Проверка произвольных направлений (для малых n)
        if not found and n <= 100:
            points = []
            for x1, y1, x2, y2 in rects:
                points.append((x1, y1))
                points.append((x1, y2))
                points.append((x2, y1))
                points.append((x2, y2))
            
            tested = set()
            m = len(points)
            
            for i in range(m):
                x1, y1 = points[i]
                for j in range(i + 1, m):
                    x2, y2 = points[j]
                    
                    dx, dy = x2 - x1, y2 - y1
                    if dx == 0 and dy == 0:
                        continue
                    
                    # Нормаль
                    a, b = dy, -dx
                    g = math.gcd(abs(a), abs(b))
                    if g > 0:
                        a //= g
                        b //= g
                    
                    if (a, b) in tested:
                        continue
                    tested.add((a, b))
                    
                    if check_dir(a, b, rects):
                        found = True
                        break
                    
                    # Противоположное направление
                    if (-a, -b) in tested:
                        continue
                    tested.add((-a, -b))
                    
                    if check_dir(-a, -b, rects):
                        found = True
                        break
                
                if found:
                    break
        
        results.append("Yes" if found else "No")
    
    sys.stdout.write('\n'.join(results))

if __name__ == "__main__":
    solve_e_full()