import sys

def solve_simple():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    
    idx = 0
    T = int(data[idx]); idx += 1
    results = []
    
    for _ in range(T):
        n = int(data[idx]); idx += 1
        rects = []
        
        for i in range(n):
            x1 = int(data[idx]); idx += 1
            y1 = int(data[idx]); idx += 1
            x2 = int(data[idx]); idx += 1
            y2 = int(data[idx]); idx += 1
            rects.append((x1, y1, x2, y2))
        
        found = False
        
        # 1. Проверка вертикальных прямых
        left_max = max(r[0] for r in rects)
        right_min = min(r[2] for r in rects)
        if left_max <= right_min:
            found = True
        
        # 2. Проверка горизонтальных прямых
        if not found:
            bottom_max = max(r[1] for r in rects)
            top_min = min(r[3] for r in rects)
            if bottom_max <= top_min:
                found = True
        
        # 3. Проверка диагональных направлений 45° и 135°
        if not found:
            # Для 45°: x + y = const
            # Найдем максимальное (x1+y1) и минимальное (x2+y2)
            max_sum_min = max(r[0] + r[1] for r in rects)  # левый нижний
            min_sum_max = min(r[2] + r[3] for r in rects)  # правый верхний
            if max_sum_min <= min_sum_max:
                found = True
            
            # Для 135°: x - y = const
            if not found:
                max_diff_min = max(r[0] - r[3] for r in rects)  # левый верхний: x1 - y2
                min_diff_max = min(r[2] - r[1] for r in rects)  # правый нижний: x2 - y1
                if max_diff_min <= min_diff_max:
                    found = True
        
        results.append("Yes" if found else "No")
    
    sys.stdout.write('\n'.join(results))

if __name__ == "__main__":
    solve_simple()