def solve_e_fast():
    import sys
    import math
    
    input_data = sys.stdin.read().split()
    if not input_data:
        return
    
    idx = 0
    T = int(input_data[idx]); idx += 1
    results = []
    
    INF = 10**30
    
    def check_direction_fast(a, b, rects):
        """Быстрая проверка направления"""
        if a == 0 and b == 0:
            return False
        
        max_min_val = -INF
        min_max_val = INF
        
        for x1, y1, x2, y2 in rects:
            # min(a*x + b*y)
            min_val = (a*x1 if a >= 0 else a*x2) + (b*y1 if b >= 0 else b*y2)
            # max(a*x + b*y)
            max_val = (a*x2 if a >= 0 else a*x1) + (b*y2 if b >= 0 else b*y1)
            
            max_min_val = max(max_min_val, min_val)
            min_max_val = min(min_max_val, max_val)
            
            if max_min_val > min_max_val:
                return False  # Ранний выход
        
        return max_min_val <= min_max_val
    
    for _ in range(T):
        n = int(input_data[idx]); idx += 1
        rects = []
        
        for i in range(n):
            x1 = int(input_data[idx]); idx += 1
            y1 = int(input_data[idx]); idx += 1
            x2 = int(input_data[idx]); idx += 1
            y2 = int(input_data[idx]); idx += 1
            rects.append((x1, y1, x2, y2))
        
        found = False
        
        # Проверка вертикальных и горизонтальных прямых
        # Вертикальные: x = const
        left_max = max(r[0] for r in rects)
        right_min = min(r[2] for r in rects)
        if left_max <= right_min:
            found = True
        
        # Горизонтальные: y = const
        if not found:
            bottom_max = max(r[1] for r in rects)
            top_min = min(r[3] for r in rects)
            if bottom_max <= top_min:
                found = True
        
        # Проверка диагональных направлений
        if not found:
            # Соберем характерные точки
            points = []
            for x1, y1, x2, y2 in rects:
                points.append((x1, y1))
                points.append((x1, y2))
                points.append((x2, y1))
                points.append((x2, y2))
            
            # Выберем несколько направлений для проверки
            # 1. Направления через противоположные углы одного прямоугольника
            test_directions = set()
            
            # Добавим направления 45° и 135° (из подзадачи 3)
            test_directions.add((1, -1))   # 45° (нормаль)
            test_directions.add((1, 1))    # 135° (нормаль)
            
            # 2. Направления между крайними точками
            if points:
                # Найдем выпуклую оболочку (упрощенно)
                min_x = min(p[0] for p in points)
                max_x = max(p[0] for p in points)
                min_y = min(p[1] for p in points)
                max_y = max(p[1] for p in points)
                
                extreme_points = [
                    (min_x, min_y), (min_x, max_y),
                    (max_x, min_y), (max_x, max_y)
                ]
                
                # Добавляем направления между этими точками
                for i in range(len(extreme_points)):
                    x1, y1 = extreme_points[i]
                    for j in range(i+1, len(extreme_points)):
                        x2, y2 = extreme_points[j]
                        dx, dy = x2 - x1, y2 - y1
                        
                        if dx == 0 and dy == 0:
                            continue
                        
                        # Нормаль
                        a, b = dy, -dx
                        g = math.gcd(abs(a), abs(b)) if a != 0 or b != 0 else 1
                        if g != 0:
                            a //= g
                            b //= g
                        
                        test_directions.add((a, b))
                        test_directions.add((-a, -b))  # Противоположное
            
            # Проверяем все собранные направления
            for a, b in test_directions:
                if check_direction_fast(a, b, rects):
                    found = True
                    break
        
        results.append("Yes" if found else "No")
    
    sys.stdout.write('\n'.join(results))

if __name__ == "__main__":
    solve_e_fast()