def solve_e():
    import sys
    
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return
    
    idx = 0
    T = int(input_data[idx]); idx += 1
    results = []
    
    for _ in range(T):
        n = int(input_data[idx]); idx += 1
        rects = []
        points = []
        
        for i in range(n):
            x1 = int(input_data[idx]); idx += 1
            y1 = int(input_data[idx]); idx += 1
            x2 = int(input_data[idx]); idx += 1
            y2 = int(input_data[idx]); idx += 1
            rects.append((x1, y1, x2, y2))
            
            # Все вершины прямоугольника
            points.append((x1, y1))
            points.append((x1, y2))
            points.append((x2, y1))
            points.append((x2, y2))
        
        # Функция проверки направления (a,b)
        def check_direction(a, b):
            if a == 0 and b == 0:
                return False
            
            global_min = float('inf')
            global_max = float('-inf')
            
            for x1, y1, x2, y2 in rects:
                # Для прямоугольника вычисляем min и max a*x + b*y
                min_val = min(a*x1, a*x2) + min(b*y1, b*y2)
                max_val = max(a*x1, a*x2) + max(b*y1, b*y2)
                
                global_min = max(global_min, min_val)
                global_max = min(global_max, max_val)
            
            return global_min <= global_max
        
        # Проверка вертикальных прямых (x = const)
        found = False
        
        # Проверим, есть ли вертикальная прямая, пересекающая все прямоугольники
        # Для этого нужно, чтобы пересечение проекций на ось X было непустым
        x_min_all = max(x1 for x1, y1, x2, y2 in rects)
        x_max_all = min(x2 for x1, y1, x2, y2 in rects)
        if x_min_all <= x_max_all:
            found = True
        
        # Проверка горизонтальных прямых (y = const)
        if not found:
            y_min_all = max(y1 for x1, y1, x2, y2 in rects)
            y_max_all = min(y2 for x1, y1, x2, y2 in rects)
            if y_min_all <= y_max_all:
                found = True
        
        # Проверка направлений через пары точек
        if not found:
            # Будем проверять направления, заданные парами точек
            # Ограничим количество проверяемых пар для эффективности
            directions_tested = set()
            
            # Выберем несколько "представительных" точек
            # Возьмем точки с минимальными и максимальными координатами
            if points:
                # Сортировка по x+y и x-y для получения разных направлений
                points_sorted_sum = sorted(points, key=lambda p: p[0] + p[1])
                points_sorted_diff = sorted(points, key=lambda p: p[0] - p[1])
                
                # Выберем несколько крайних точек
                test_points = []
                test_points.append(points_sorted_sum[0])  # min(x+y)
                test_points.append(points_sorted_sum[-1]) # max(x+y)
                test_points.append(points_sorted_diff[0]) # min(x-y)
                test_points.append(points_sorted_diff[-1]) # max(x-y)
                
                # Добавим еще случайные точки
                import random
                if len(points) > 10:
                    test_points.extend(random.sample(points, min(10, len(points))))
                else:
                    test_points.extend(points)
                
                # Уникальные точки
                test_points = list(set(test_points))
                
                # Проверяем пары точек
                for i in range(len(test_points)):
                    x1, y1 = test_points[i]
                    for j in range(i+1, len(test_points)):
                        x2, y2 = test_points[j]
                        
                        # Вычисляем направление
                        dx = x2 - x1
                        dy = y2 - y1
                        
                        # Нормализуем направление (приводим к каноническому виду)
                        if dx == 0 and dy == 0:
                            continue
                        
                        # Приводим к виду с gcd=1
                        import math
                        g = math.gcd(abs(dx), abs(dy))
                        if g != 0:
                            dx //= g
                            dy //= g
                        
                        # Убедимся, что направление уникально
                        dir_key = (dx, dy)
                        if dir_key in directions_tested:
                            continue
                        directions_tested.add(dir_key)
                        
                        # Проверяем это направление и противоположное
                        if check_direction(dy, -dx):  # нормаль к прямой (dx, dy)
                            found = True
                            break
                        if check_direction(-dy, dx):  # противоположное направление
                            found = True
                            break
                    
                    if found:
                        break
        
        results.append("Yes" if found else "No")
    
    print('\n'.join(results))

if __name__ == "__main__":
    solve_e()