MOD = 10**9 + 7

def solve():
    import sys
    
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return
    
    n = int(input_data[0])
    K = int(input_data[1])
    R_str = input_data[2]
    
    # Преобразуем R в двоичную строку
    R = int(R_str)
    if R == 0:
        # Особый случай: только число 0
        print(1 if 0 % K == 0 else 0)
        return
    
    binary_R = bin(R)[2:]  # Двоичное представление без '0b'
    L = len(binary_R)
    
    # DP[pos][rem][tight]
    dp = [[[0, 0] for _ in range(K)] for _ in range(L + 1)]
    
    # Начальное состояние: позиция 0, 0 единиц, tight = 1
    dp[0][0][1] = 1
    
    for pos in range(L):
        current_bit = int(binary_R[pos])
        
        for rem in range(K):
            for tight in range(2):
                if dp[pos][rem][tight] == 0:
                    continue
                
                current_val = dp[pos][rem][tight]
                
                # Выбираем следующий бит
                max_bit = 1 if tight == 0 else current_bit
                
                for bit in range(max_bit + 1):
                    new_rem = (rem + bit) % K
                    new_tight = 1 if (tight == 1 and bit == current_bit) else 0
                    
                    dp[pos + 1][new_rem][new_tight] = (
                        dp[pos + 1][new_rem][new_tight] + current_val
                    ) % MOD
    
    # Ответ: все числа от 0 до R включительно, где popcount % K == 0
    # Учитываем tight = 0 и tight = 1
    result = 0
    for tight in range(2):
        result = (result + dp[L][0][tight]) % MOD
    
    print(result)

if __name__ == "__main__":
    solve()