import sys
MOD = 10**9 + 7

def modpow(a, e, mod):
    res = 1
    while e:
        if e & 1:
            res = res * a % mod
        a = a * a % mod
        e >>= 1
    return res

def prepare_fact(n, mod=MOD):
    fact = [1] * (n+1)
    invfact = [1] * (n+1)
    for i in range(1, n+1):
        fact[i] = fact[i-1] * i % mod
    invfact[n] = modpow(fact[n], mod-2, mod)
    for i in range(n, 0, -1):
        invfact[i-1] = invfact[i] * i % mod
    return fact, invfact

def C(n, k, fact, invfact):
    if k < 0 or k > n:
        return 0
    return fact[n] * invfact[k] % MOD * invfact[n-k] % MOD

def compute_S_direct(rem, r, K, fact, invfact):
    # sum_{s=r, r+K, ... <= rem} C(rem, s)
    s = r
    total = 0
    while s <= rem:
        total += C(rem, s, fact, invfact)
        if total >= MOD:
            total -= MOD
        s += K
    return total
def solve():
    data = sys.stdin.read().strip().split()
    n = int(data[0]); K = int(data[1])
    R_str = data[2].lstrip('0')
    if R_str == "":
        R_str = "0"
    # trivial cases
    if K == 1:
        # все x подходят
        # количество x in [0,R] = R+1 modulo MOD
        R_int = int(R_str)
        print((R_int + 1) % MOD)
        return
    # конвертируем в int (Python поддерживает большие int)
    R_int = int(R_str)
    bits = bin(R_int)[2:]
    L = len(bits)
    fact, invfact = prepare_fact(L)
    # Сначала подготовка: посчитаем popcount(R) чтобы учесть R сам
    popR = bits.count('1')
    # Если K > L, то единственное t≡0 modK в [0..L] это t=0, т.е. мы считаем числа с нулём единиц — только число 0
    if K > L:
        # только x==0 имеет popcount 0
        print(1 if R_int >= 0 else 0)
        return
    ans = 0
    ones_so_far = 0