def solve() -> None:
    import sys

    input = sys.stdin.read
    data = input().split()
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    # Решето для нахождения наименьшего простого делителя
    N = r + 1
    lp = [0] * N
    primes = []
    for i in range(2, N):
        if lp[i] == 0:
            lp[i] = i
            primes.append(i)
        for p in primes:
            if p > lp[i] or i * p >= N:
                break
            lp[i * p] = p

    # Массив is_good[i] = True, если i — нечётно-степенное
    is_good = [False] * (r + 1)
    is_good[0] = is_good[1] = False

    for num in range(2, r + 1):
        n = num
        good = True
        # Разложение на простые множители
        while n > 1:
            p = lp[n]
            cnt = 0
            while n % p == 0:
                n //= p
                cnt += 1
            if cnt % 2 == 0:
                good = False
                break
        is_good[num] = good

    # Поиск последовательности длины m
    streak = 0
    start = -1
    for x in range(l, r + 1):
        if is_good[x]:
            streak += 1
            if streak >= m:
                start = x - m + 1
                break
        else:
            streak = 0

    if start == -1:
        print(-1)
    else:
        print(' '.join(str(start + i) for i in range(m)))


if __name__ == "__main__":
    solve()