def count_magic(n: int) -> int:
    if n < 7:
        return 0
    return n // 7 + (n - 7) // 10 - (n - 7) // 70

def solve() -> None:
    import sys
    k = int(sys.stdin.readline().strip())
    
    # Бинарный поиск
    lo, hi = 1, 10**18  # верхняя граница большая, чтобы покрыть k до 10^17
    while lo < hi:
        mid = (lo + hi) // 2
        if count_magic(mid) >= k:
            hi = mid
        else:
            lo = mid + 1
    print(lo)

if __name__ == "__main__":
    solve()