def solve_a():
    import sys
    
    data = sys.stdin.read().strip().split()
    if not data:
        return
    
    n = int(data[0])
    m = int(data[1])
    k = int(data[2])
    
    # Вычисляем cnt_i[r] - количество строк i с остатком r при делении на k
    cnt_i = [0] * k
    for r in range(k):
        # Остаток r (0 ≤ r < k)
        # Количество чисел от 1 до n с остатком r при делении на k
        if r == 0:
            # Числа: k, 2k, 3k, ...
            cnt_i[r] = n // k
        else:
            # Числа: r, k+r, 2k+r, ...
            if r > n:
                cnt_i[r] = 0
            else:
                cnt_i[r] = (n - r) // k + 1
    
    # Вычисляем cnt_j[r] - количество столбцов j с остатком r при делении на k
    cnt_j = [0] * k
    for r in range(k):
        if r == 0:
            cnt_j[r] = m // k
        else:
            if r > m:
                cnt_j[r] = 0
            else:
                cnt_j[r] = (m - r) // k + 1
    
    # Вычисляем ответ для каждого цвета
    result = [0] * k
    for c in range(k):
        total = 0
        for r_i in range(k):
            # Нужный остаток для j
            r_j = (c + 2 - r_i) % k
            total += cnt_i[r_i] * cnt_j[r_j]
        result[c] = total
    
    # Вывод
    print('\n'.join(map(str, result)))

if __name__ == "__main__":
    solve_a()