def can_draw_line(x1, y1, x2, y2):
    # Проверка, что клетки лежат на одной линии:
    # - по горизонтали: y1 == y2
    # - по вертикали: x1 == x2
    # - по диагонали: abs(x2 - x1) == abs(y2 - y1)
    return (x1 == x2) or (y1 == y2) or (abs(x2 - x1) == abs(y2 - y1))

def solve():
    T = int(input().strip())  # количество клеток
    coords = []
    for _ in range(T):
        x, y = map(int, input().split())
        coords.append((x, y))
    
    # Проверяем все пары клеток, можно ли провести линию между ними
    # согласно условию, что линии не пересекаются с препятствиями
    # и клетки лежат на одной линии
    for i in range(T):
        for j in range(i + 1, T):
            x1, y1 = coords[i]
            x2, y2 = coords[j]
            if can_draw_line(x1, y1, x2, y2):
                # Если есть хотя бы одна пара, которая может соединиться линией
                print("Yes")
                return
    print("No")

# Чтение числа наборов данных
k = int(input())
for _ in range(k):
    solve()
