import sys

MOD = 10**9 + 7

def decimal_to_binary(decimal_str):
    """Преобразует десятичную строку в список битов (старший бит первый)."""
    bits = []
    num = [int(ch) for ch in decimal_str]
    while any(d != 0 for d in num):
        remainder = 0
        new_num = []
        for d in num:
            current = remainder * 10 + d
            new_num.append(current // 2)
            remainder = current % 2
        bits.append(remainder)
        num = new_num
        # Убираем ведущие нули в num
        while len(num) > 0 and num[0] == 0:
            num.pop(0)
    if not bits:
        bits = [0]
    bits.reverse()  # теперь старший бит в bits[0]
    return bits

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R_str = data[2]

    bits = decimal_to_binary(R_str)  # старший бит первый
    m = len(bits)

    # dp[rem][tight] для текущей позиции
    dp = [[0, 0] for _ in range(K)]
    dp[0][1] = 1  # начальное состояние: длина 0, остаток 0, tight=1

    for pos in range(m):
        bit_R = bits[pos]
        new_dp = [[0, 0] for _ in range(K)]
        for rem in range(K):
            for tight in (0, 1):
                val = dp[rem][tight]
                if val == 0:
                    continue
                max_bit = bit_R if tight else 1
                for b in (0, 1):
                    if b > max_bit:
                        continue
                    new_tight = 1 if (tight and b == bit_R) else 0
                    new_rem = (rem + b) % K
                    new_dp[new_rem][new_tight] = (new_dp[new_rem][new_tight] + val) % MOD
        dp = new_dp

    answer = (dp[0][0] + dp[0][1]) % MOD
    print(answer)

if __name__ == "__main__":
    solve()
