import sys

MOD = 10 ** 9 + 7


def solve():
    input_data = sys.stdin.read().split()
    n_str, K_str = input_data[0], input_data[1]
    n = int(n_str)
    K = int(K_str)
    R_str = input_data[2]

    R_bits = []
    num = 0
    # Преобразуем десятичную строку R в двоичную без ведущих нулей
    # Постепенно обрабатываем десятичные цифры, преобразуя в двоичное представление
    for ch in R_str:
        digit = ord(ch) - ord('0')
        carry = digit
        for i in range(len(R_bits)):
            val = R_bits[i] * 10 + carry
            R_bits[i] = val & 1
            carry = val >> 1
        while carry:
            R_bits.append(carry & 1)
            carry >>= 1
    # Теперь R_bits содержит двоичные цифры, младший бит в начале
    # Перевернём, чтобы старший бит был в начале (для удобства DP)
    R_bits.reverse()
    m = len(R_bits)

    # Динамика: dp[pos][rem][tight]
    # pos: текущая позиция в двоичном представлении (от старшего бита)
    # rem: остаток количества единиц по модулю K
    # tight: 1 если текущий префикс равен префиксу R, 0 если уже меньше
    dp = [[[0, 0] for _ in range(K)] for _ in range(m + 1)]
    dp[0][0][1] = 1

    for pos in range(m):
        bit_R = R_bits[pos]
        for rem in range(K):
            for tight in range(2):
                if dp[pos][rem][tight] == 0:
                    continue
                val = dp[pos][rem][tight]
                # Пробуем поставить бит 0
                max_bit = bit_R if tight else 1
                for b in range(0, max_bit + 1):
                    new_tight = 1 if (tight and b == bit_R) else 0
                    new_rem = (rem + b) % K
                    dp[pos + 1][new_rem][new_tight] = (dp[pos + 1][new_rem][new_tight] + val) % MOD

    # Ответ: dp[m][0][0] + dp[m][0][1] (все числа <= R)
    answer = (dp[m][0][0] + dp[m][0][1]) % MOD
    print(answer)


if __name__ == "__main__":
    solve()
