import sys

def count_with_remainder(n, r, k):
    """
    Количество чисел в [1, n] с остатком r по модулю k
    """
    if r == 0:
        return n // k
    else:
        if r > n:
            return 0
        return (n - r) // k + 1

def main():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n, m, k = map(int, data)
    
    ans = [0] * k
    
    for color in range(k):
        t = (color + 2) % k
        total = 0
        for p in range(k):
            a = (t - p) % k
            cnt_i = count_with_remainder(n, p, k)
            cnt_j = count_with_remainder(m, a, k)
            total += cnt_i * cnt_j
        ans[color] = total
    
    print(' '.join(map(str, ans)))

if __name__ == "__main__":
    main()
