﻿#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    
    long long n, m, k;
    cin >> n >> m >> k;
    
    vector<long long> ans(k, 0);
    
    // Количество диагоналей
    long long total_diags = n + m - 1;
    long long min_nm = min(n, m);
    long long max_nm = max(n, m);
    
    // Для каждого остатка от деления номера диагонали на k
    for (int r = 0; r < k; r++) {
        long long sum = 0;
        
        // Рассматриваем все диагонали с номером d ≡ r (mod k)
        for (long long d = r; d < total_diags; d += k) {
            if (d < min_nm) {
                // Растущая часть: d+1 клеток
                sum += (d + 1);
            } else if (d < max_nm) {
                // Средняя часть: min(n, m) клеток
                sum += min_nm;
            } else {
                // Убывающая часть: (n+m-1-d) клеток
                sum += (total_diags - d);
            }
        }
        
        ans[r] = sum;
    }
    
    // Выводим ответ (цвет 1 соответствует остатку 0, цвет 2 - остатку 1, и т.д.)
    for (int i = 0; i < k; i++) {
        cout << ans[i] << '\n';
    }
    
    return 0;
}