﻿#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

typedef long long ll;

// Сумма арифметической прогрессии: a + (a+d) + (a+2d) + ... + last
ll sum_ap(ll a, ll d, ll last) {
    if (a > last) return 0;
    ll n = (last - a) / d + 1;
    return n * (a + last) / 2;
}

// Количество элементов в прогрессии: a, a+k, a+2k, ..., <= last
ll count_in_ap(ll a, ll k, ll last) {
    if (a > last) return 0;
    return (last - a) / k + 1;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    ll n, m, k;
    cin >> n >> m >> k;

    vector<ll> res(k + 1, 0); // res[i] — количество клеток цвета i

    ll min_nm = min(n, m);
    ll max_nm = max(n, m);

    // Для каждого цвета от 1 до k
    for (int color = 1; color <= k; ++color) {
        ll total = 0;
        ll r = color - 1; // d ≡ r (mod k)

        // Участок 1: d ∈ [1, min_nm], cells(d) = d
        ll L1 = 1, R1 = min_nm;
        if (L1 <= R1) {
            // Найти первое d >= L1, d ≡ r (mod k)
            ll first = ((L1 - r + k - 1) / k) * k + r;
            if (first < L1) first += k;
            if (first <= R1) {
                ll last = R1 - ((R1 - r) % k);
                if (last >= first) {
                    total += sum_ap(first, k, last);
                }
            }
        }

        // Участок 2: d ∈ [min_nm+1, max_nm], cells(d) = min_nm
        ll L2 = min_nm + 1, R2 = max_nm;
        if (L2 <= R2) {
            ll first = ((L2 - r + k - 1) / k) * k + r;
            if (first < L2) first += k;
            if (first <= R2) {
                ll last = R2 - ((R2 - r) % k);
                if (last >= first) {
                    ll cnt = (last - first) / k + 1;
                    total += cnt * min_nm;
                }
            }
        }

        // Участок 3: d ∈ [max_nm+1, n+m-1], cells(d) = n + m - d
        ll L3 = max_nm + 1, R3 = n + m - 1;
        if (L3 <= R3) {
            ll first = ((L3 - r + k - 1) / k) * k + r;
            if (first < L3) first += k;
            if (first <= R3) {
                ll last = R3 - ((R3 - r) % k);
                if (last >= first) {
                    ll cnt = (last - first) / k + 1;
                    // Сумма (n+m-d) = cnt*(n+m) - sum(d)
                    ll sum_d = sum_ap(first, k, last);
                    total += cnt * (n + m) - sum_d;
                }
            }
        }

        res[color] = total;
    }

    for (int i = 1; i <= k; ++i) {
        cout << res[i] << " ";
    }
    cout << endl;

    return 0;
}