﻿Задача требует посчитать, сколько клеток каждого цвета будет в прямоугольнике \( n \times m \), если раскрашивать диагонали в \( k \) цветов циклически, начиная с цвета 1 для клетки (1,1).  

Основная идея:  
- Клетка \((i, j)\) принадлежит диагонали с номером \( d = i + j - 2 \) (нумерация с 0).  
- Цвет определяется как \( (d \bmod k) + 1 \).  
- Нам нужно для каждого цвета \( c \) от 1 до \( k \) посчитать, сколько клеток в прямоугольнике имеют \( (i + j - 2) \bmod k = c - 1 \).

---

### Математическая формула

Пусть \( D = i + j - 2 \).  
Тогда \( D \) может быть от 0 до \( n + m - 2 \).  
Для каждого \( D \) количество клеток с данной суммой координат:  
- Если \( D < \min(n, m) \), то количество клеток \( = D + 1 \).  
- Если \( \min(n, m) \le D < \max(n, m) \), то количество клеток \( = \min(n, m) \).  
- Если \( \max(n, m) \le D \le n + m - 2 \), то количество клеток \( = n + m - 1 - D \).

Но перебирать все \( D \) до \( 2 \cdot 10^6 \) можно, если аккуратно (O(n+m)), а лучше — сразу вывести формулу для подсчёта без перебора.

---

### Упрощение

Для каждого остатка \( r = 0 \dots k-1 \) (цвет \( r+1 \)) нужно просуммировать количество клеток, у которых \( (i+j-2) \mod k = r \).

Можно считать так:  
Пусть \( total \) — общее число клеток \( n \times m \).  
Базово каждому остатку достанется \( \lfloor \frac{total}{k} \rfloor \) клеток, плюс дополнительные клетки для некоторых остатков из-за остатка от деления.

Более точно:  
Посмотрим на все значения \( D = 0 \dots (n+m-2) \).  
Для каждого \( D \) известно количество клеток \( cnt(D) \) (описанное выше).  
Нужно раздать \( cnt(D) \) клеток остатку \( D \bmod k \).

Это можно сделать за O(k) или O(n+m), но n+m может быть до 4·10⁶, что допустимо за 0.5 секунд.

---

### Реализация за O(n+m)

Мы перебираем D от 0 до n+m-2, вычисляем cnt(D) и добавляем к соответствующему остатку.  
Так как n,m ≤ 2·10⁶, n+m ≤ 4·10⁶ — это нормально для 0.5 секунд.

---

Вот код на C++:

```cpp
#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    long long n, m, k;
    cin >> n >> m >> k;
    
    vector<long long> colorCount(k, 0);
    
    // D = i+j-2, от 0 до n+m-2
    for (long long d = 0; d <= n + m - 2; ++d) {
        // Количество клеток с данной суммой координат
        long long cnt;
        if (d < min(n, m)) {
            cnt = d + 1;
        } else if (d < max(n, m)) {
            cnt = min(n, m);
        } else {
            cnt = n + m - 1 - d;
        }
        
        // Определяем цвет
        int color = d % k; // 0..k-1 соответствует цветам 1..k
        colorCount[color] += cnt;
    }
    
    // Вывод
    for (int i = 0; i < k; ++i) {
        cout << colorCount[i] << "\n";
    }
    
    return 0;
}
```