import sys

input = sys.stdin.read
T = int(input().split()[0])
index = 1
results = []

for _ in range(T):
    n = int(input().split()[index])
    index += 1

    x_min, y_min = 10 ** 10, 10 ** 10
    x_max, y_max = -1, -1

    for __ in range(n):
        x1, y1, x2, y2 = map(int, input().split()[index:index + 4])
        index += 4
        x_min = min(x_min, x1)
        y_min = min(y_min, y1)
        x_max = max(x_max, x2)
        y_max = max(y_max, y2)

    # Теперь проверяем, есть ли общая касательная
    # Для касания всех прямоугольников, должна существовать линия,
    # которая касается хотя бы одного из их краев.
    # В данном случае, если диапазоны пересекаются, ответ "Yes", иначе "No".

    # Однако, по условию, комната не пересекается, но может касаться.
    # Значит, достаточно проверить, есть ли пересечение по границам.
    # Если диапазоны по x и y не пересекаются, значит касательная не может их одновременно касаться.

    # Но поскольку касание — это касание по стороне или вершине,
    # то достаточно проверить, что диапазоны по x и y пересекаются.

    # Условие:
    # Есть ли в диапазонах x и y пересечения?
    # Так как комнаты не накладываются:
    # - Область пересечения по x: [x_min, x_max]
    # - Область пересечения по y: [y_min, y_max]

    # Если диапазоны по x и y не пересекаются, ответ "No"
    # иначе — "Yes"

    # Внимание: по условию, комнаты не накладываются, но могут касаться.
    # Тогда касание возможно, если существует точка, которая одновременно касается всех комнат.
    # Для этого достаточно, чтобы диапазоны по x и y пересекались.

    # Проверка:
    if x_min <= x_max and y_min <= y_max:
        results.append("Yes")
    else:
        results.append("No")

print("\n".join(results))
