MOD = 10 ** 9 + 7


def solve():
    import sys
    sys.setrecursionlimit(10 ** 7)

    R_str = sys.stdin.read().strip().split()[0]
    K = int(sys.stdin.read().strip().split()[1])

    R_bin = bin(int(R_str))[2:]  # двоичное представление R

    from functools import lru_cache

    @lru_cache(None)
    def dfs(pos, pop_mod, tight):
        # Если дошли до конца
        if pos == len(R_bin):
            # Проверяем условие
            return 1 if pop_mod == 0 else 0

        limit = int(R_bin[pos]) if tight else 1
        result = 0
        for bit in range(limit + 1):
            next_tight = tight and (bit == limit)
            next_pop_mod = (pop_mod + bit) % K
            result += dfs(pos + 1, next_pop_mod, next_tight)
        return result % MOD

    answer = dfs(0, 0, True)
    print(answer)


if __name__ == "__main__":
    solve()
