import sys
input = sys.stdin.read

def precompute(max_limit):
    # Создаем массив, где True — число нечётно-степенное
    is_odd_power = [False] * (max_limit + 1)
    # Обрабатываем каждое число
    for num in range(2, max_limit + 1):
        # Проверяем разложение на простые множители
        temp = num
        # Храним признак, что все степени нечётные
        all_odd = True
        # Простое деление
        for div in range(2, int(temp**0.5) + 1):
            count = 0
            while temp % div == 0:
                temp //= div
                count += 1
            if count > 0:
                if count % 2 == 0:
                    all_odd = False
                    break
        if temp > 1:
            # остался делитель — простое число
            # степень 1 — нечетная
            # все хорошо
            pass
        else:
            # все делители проверены
            pass
        is_odd_power[num] = all_odd
    return is_odd_power

def main():
    data = input().split()
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    max_limit = 10**6
    is_odd_power = precompute(max_limit)

    count = 0
    start_idx = -1
    for num in range(l, r+1):
        if is_odd_power[num]:
            count += 1
            if count == 1:
                start_idx = num
            if count == m:
                print(' '.join(str(x) for x in range(start_idx, start_idx + m)))
                return
        else:
            count = 0

    print(-1)

if __name__ == "__main__":
    main()
