n = int(input())
m = int(input())
k = int(input())

total_cells = n * m
counts = [0] * k

# Общее число диагоналей
total_diags = n + m - 1

for r in range(k):
    # sum s, где s ≡ r mod k
    # s идет по диапазону от 2 до n + m
    # s ≡ r mod k
    # начинаем с s0 >= 2, s0 ≡ r mod k
    s_start = 2
    rem_start = (s_start - r + k) % k
    if rem_start != 0:
        s_start += (k - rem_start)
    # s_end <= n + m
    s_end = n + m
    rem_end = (s_end - r) % k
    if rem_end != 0:
        s_end -= rem_end

    if s_start > s_end:
        continue

    # Количество s, где s ≡ r mod k
    count_s = ((s_end - s_start) // k) + 1

    # Для каждого s в диапазоне вычисляем количество клеток
    # Можно посчитать сумму по формуле
    total_for_color = 0
    for s in range(s_start, s_end + 1, k):
        min_i = max(1, s - m)
        max_i = min(n, s - 1)
        count = max(0, max_i - min_i + 1)
        total_for_color += count

    counts[r] = total_for_color

# Выводим результаты
for c in counts:
    print(c)
