import sys

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    t = int(data[0])
    idx = 1
    out_lines = []
    
    for _ in range(t):
        n = int(data[idx]); idx += 1
        rects = []
        for __ in range(n):
            x1 = int(data[idx]); y1 = int(data[idx+1])
            x2 = int(data[idx+2]); y2 = int(data[idx+3])
            idx += 4
            rects.append((x1, y1, x2, y2))
        
        # Проверка вертикальных прямых
        left_max = -10**9
        right_min = 10**9
        for x1, y1, x2, y2 in rects:
            left_max = max(left_max, x1)
            right_min = min(right_min, x2)
        vertical_ok = left_max <= right_min
        
        # Проверка горизонтальных прямых
        bottom_max = -10**9
        top_min = 10**9
        for x1, y1, x2, y2 in rects:
            bottom_max = max(bottom_max, y1)
            top_min = min(top_min, y2)
        horizontal_ok = bottom_max <= top_min
        
        # Проверка прямых y = x + c (45°)
        min_c_max = -10**9
        max_c_min = 10**9
        for x1, y1, x2, y2 in rects:
            min_c = y1 - x2
            max_c = y2 - x1
            min_c_max = max(min_c_max, min_c)
            max_c_min = min(max_c_min, max_c)
        diag45_ok = min_c_max <= max_c_min
        
        # Проверка прямых y = -x + c (135°)
        min_w_max = -10**9
        max_w_min = 10**9
        for x1, y1, x2, y2 in rects:
            min_w = y1 + x1
            max_w = y2 + x2
            min_w_max = max(min_w_max, min_w)
            max_w_min = min(max_w_min, max_w)
        diag135_ok = min_w_max <= max_w_min
        
        if vertical_ok or horizontal_ok or diag45_ok or diag135_ok:
            out_lines.append("Yes")
        else:
            out_lines.append("No")
    
    sys.stdout.write("\n".join(out_lines))

if __name__ == "__main__":
    solve()
