python
import sys

def solve():
    data = sys.stdin.read().strip().split()
    it = iter(data)
    t = int(next(it))
    out_lines = []
    for _ in range(t):
        n = int(next(it))
        x1_list = []
        y1_list = []
        x2_list = []
        y2_list = []
        for __ in range(n):
            x1 = int(next(it))
            y1 = int(next(it))
            x2 = int(next(it))
            y2 = int(next(it))
            x1_list.append(x1)
            y1_list.append(y1)
            x2_list.append(x2)
            y2_list.append(y2)
        
        # 1. vertical line
        x_left_max = max(x1_list)
        x_right_min = min(x2_list)
        if x_left_max <= x_right_min:
            out_lines.append("Yes")
            continue
        
        # 2. horizontal line
        y_bottom_max = max(y1_list)
        y_top_min = min(y2_list)
        if y_bottom_max <= y_top_min:
            out_lines.append("Yes")
            continue
        
        # 3. k = 1 line
        lower = max(y1 - x2 for y1, x2 in zip(y1_list, x2_list))
        upper = min(y2 - x1 for y2, x1 in zip(y2_list, x1_list))
        if lower <= upper:
            out_lines.append("Yes")
            continue
        
        # 4. k = -1 line
        lower2 = max(y1 + x1 for y1, x1 in zip(y1_list, x1_list))
        upper2 = min(y2 + x2 for y2, x2 in zip(y2_list, x2_list))
        if lower2 <= upper2:
            out_lines.append("Yes")
            continue
        
        out_lines.append("No")
    
    sys.stdout.write("\n".join(out_lines))

if __name__ == "__main__":
    solve()
