import sys

MOD = 10**9 + 7

def solve():
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    K = int(data[1])
    R_str = data[2]
    
    R_int = int(R_str)
    
    # Если K > 60, то popcount <= 60 для R <= 2^60, но у нас R огромное, m ~ len(bin(R))-2
    # Для больших K, если K > m, ответ 1 (только число 0)
    # Сначала получим двоичную строку R
    R_bin = bin(R_int)[2:]  # но R_int может не влезть в int, если n=30000
    # Поэтому лучше преобразовывать строку в двоичную без перевода в int
    # Но для простоты сначала напишем для R, помещающегося в int
    
    # Полный алгоритм с переводом в двоичную
    R_bin = bin(int(R_str))[2:]
    m = len(R_bin)
    
    if K > m:
        # popcount может быть только от 0 до m, если K > m, то кратно K может быть только 0
        # popcount=0 только у числа 0
        # Но 0 ≤ z ≤ R, так что z=0 всегда подходит
        print(1 % MOD)
        return
    
    # DP: dp[tight][rem]
    dp = [[0] * K for _ in range(2)]
    dp[1][0] = 1  # начальное состояние: tight=1, popcount=0
    
    for i, ch in enumerate(R_bin):
        new_dp = [[0] * K for _ in range(2)]
        bit = int(ch)
        for tight in (0, 1):
            for rem in range(K):
                cur = dp[tight][rem]
                if cur == 0:
                    continue
                # ставим 0
                max_bit = bit if tight else 1
                for b in (0, 1):
                    if tight and b > bit:
                        continue
                    new_tight = tight and (b == bit)
                    new_rem = (rem + b) % K
                    new_dp[new_tight][new_rem] = (new_dp[new_tight][new_rem] + cur) % MOD
        dp = new_dp
    
    # Ответ: сумма dp[0][0] + dp[1][0] (все tight варианты с остатком 0)
    ans = (dp[0][0] + dp[1][0]) % MOD
    print(ans)

if __name__ == "__main__":
    solve()
