import sys

def solve():
    input = sys.stdin.read
    data = input().split()
    
    n = int(data[0])
    K = int(data[1])
    R_str = data[2]
    
    MOD = 10**6 + 7
    
    # 1. Конвертируем десятичное число R в двоичную строку
    # Используем алгоритм деления на 2 для больших чисел
    def decimal_to_binary(s):
        """Конвертирует десятичную строку в двоичную строку"""
        binary_digits = []
        while s != '0':
            # Вычисляем остаток от деления на 2
            remainder = 0
            new_s = []
            for ch in s:
                current = remainder * 10 + (ord(ch) - ord('0'))
                new_s.append(str(current // 2))
                remainder = current % 2
            # Последний remainder - это текущий бит (младший)
            binary_digits.append(str(remainder))
            
            # Убираем ведущие нули из new_s
            s = ''.join(new_s).lstrip('0')
            if not s:
                s = '0'
        # Бинарные цифры собраны в обратном порядке
        binary_digits.reverse()
        if not binary_digits:
            return '0'
        return ''.join(binary_digits)
    
    binary_R = decimal_to_binary(R_str)
    m = len(binary_R)
    
    # 2. Динамическое программирование
    # dp[cnt][tight] - количество способов
    dp = [[0, 0] for _ in range(K)]
    dp[0][1] = 1  # Начальное состояние: пустой префикс, tight=1, cnt=0
    
    for pos in range(m):
        new_dp = [[0, 0] for _ in range(K)]
        bit_R = int(binary_R[pos])
        
        for cnt in range(K):
            for tight in (0, 1):
                ways = dp[cnt][tight]
                if ways == 0:
                    continue
                
                # Перебираем возможную цифру на текущей позиции (0 или 1)
                max_bit = 1 if tight == 0 else bit_R
                
                for bit in range(max_bit + 1):
                    new_tight = 1 if (tight == 1 and bit == bit_R) else 0
                    new_cnt = (cnt + bit) % K
                    new_dp[new_cnt][new_tight] = (new_dp[new_cnt][new_tight] + ways) % MOD
        
        dp = new_dp
    
    # Ответ: все числа от 0 до R включительно, где cnt ≡ 0 (mod K)
    # tight может быть 0 или 1 (оба допустимы в конце)
    answer = (dp[0][0] + dp[0][1]) % MOD
    print(answer)

if __name__ == "__main__":
    solve()
