python
import sys

def solve() -> None:
    data = sys.stdin.read().strip().split()
    if not data:
        return
    n = int(data[0])
    m = int(data[1])
    k = int(data[2])

    p = min(n, m)
    q = max(n, m)
    ans = [0] * k

    # Функция для добавления сегмента
    def add_segment(L: int, R: int, a: int, b: int) -> None:
        if L > R:
            return
        for c in range(k):
            # Вычисляем t_min и t_max для d = k*t + c
            if L > c:
                t_min = (L - c + k - 1) // k
            else:
                t_min = 0 if c <= R else 1  # специальный случай
            
            t_max = (R - c) // k
            if t_max < t_min:
                continue
            
            cnt = t_max - t_min + 1
            # sum_t = t_min + (t_min+1) + ... + t_max
            sum_t = (t_min + t_max) * cnt // 2
            ans[c] += a * k * sum_t + (a * c + b) * cnt

    # Сегмент 1: возрастание
    add_segment(0, p - 1, 1, 1)
    # Сегмент 2: плато
    add_segment(p, q - 1, 0, p)
    # Сегмент 3: убывание
    add_segment(q, p + q - 2, -1, p + q - 1)

    # Вывод в правильном порядке (цвета 1..k)
    sys.stdout.write(' '.join(map(str, ans)))

if __name__ == "__main__":
    solve()
