def solve():
    import sys
    import math

    n, m, k = map(int, sys.stdin.readline().split())

    n_min = min(n, m)
    n_max = max(n, m)

    ans = [0] * k

    for c in range(k):
        a = 2 + c  # начальное s для цвета c при t=0

        # 1. Растущая часть: s от 2 до n_min+1, count = s-1
        L1, R1 = 2, n_min + 1
        # Находим первое s >= L1, принадлежащее прогрессии a + k*t
        if a > R1:
            t_min1 = None
        else:
            # t_min = ceil((L1 - a) / k)
            diff = L1 - a
            if diff <= 0:
                t_min1 = 0
            else:
                t_min1 = (diff + k - 1) // k
            # t_max = floor((R1 - a) / k)
            t_max1 = (R1 - a) // k
            if t_min1 <= t_max1:
                s_first = a + k * t_min1
                s_last = a + k * t_max1
                cnt = t_max1 - t_min1 + 1
                # сумма s = арифметическая прогрессия
                sum_s = cnt * (s_first + s_last) // 2
                ans[c] += sum_s - cnt  # вычитаем cnt, так как count = s-1

        # 2. Плоская часть: s от n_min+1 до n_max+1, count = n_min
        L2, R2 = n_min + 1, n_max + 1
        if a <= R2:
            diff = L2 - a
            if diff <= 0:
                t_min2 = 0
            else:
                t_min2 = (diff + k - 1) // k
            t_max2 = (R2 - a) // k
            if t_min2 <= t_max2:
                cnt = t_max2 - t_min2 + 1
                ans[c] += cnt * n_min

        # 3. Убывающая часть: s от n_max+1 до n+m, count = n+m-s+1
        L3, R3 = n_max + 1, n + m
        if a <= R3:
            diff = L3 - a
            if diff <= 0:
                t_min3 = 0
            else:
                t_min3 = (diff + k - 1) // k
            t_max3 = (R3 - a) // k
            if t_min3 <= t_max3:
                s_first = a + k * t_min3
                s_last = a + k * t_max3
                cnt = t_max3 - t_min3 + 1
                sum_s = cnt * (s_first + s_last) // 2
                ans[c] += cnt * (n + m + 1) - sum_s

    # Выводим результат
    print("\n".join(map(str, ans)))


if __name__ == "__main__":
    solve()
