MOD = 10**9 + 7

import sys
input = sys.stdin.readline

def prepare_factorials(nmax, mod=MOD):
    fact = [1] * (nmax + 1)
    invfact = [1] * (nmax + 1)
    for i in range(1, nmax + 1):
        fact[i] = fact[i-1] * i % mod
    invfact[nmax] = pow(fact[nmax], mod-2, mod)
    for i in range(nmax, 0, -1):
        invfact[i-1] = invfact[i] * i % mod
    return fact, invfact

def C(n, k, fact, invfact, mod=MOD):
    if k < 0 or k > n:
        return 0
    return fact[n] * invfact[k] % mod * invfact[n-k] % mod


line = input().strip().split()

if len(line) == 2:
    n = int(line[0]); K = int(line[1])
    R = input().strip()
else:

    raise ValueError("Unexpected input format")


R_int = int(R)
binR = bin(R_int)[2:]
L = len(binR)


fact, invfact = prepare_factorials(L, MOD)


s = 0
answer = 0


for i, bit in enumerate(binR):
    pos = i
    remaining = L - pos - 1

    if bit == '1':

        if remaining >= 0:
            u0 = (-s) % K

            if u0 <= remaining:

                u = u0
                while u <= remaining:
                    answer = (answer + C(remaining, u, fact, invfact, MOD)) % MOD
                    u += K

        s += 1

    else:

        pass


if binR.count('1') % K == 0:
    answer = (answer + 1) % MOD

print(answer % MOD)