import sys
input = sys.stdin.readline

MAXN = 10**6
spf = list(range(MAXN + 1))

for i in range(2, int(MAXN**0.5) + 1):
    if spf[i] == i:
        for j in range(i * i, MAXN + 1, i):
            if spf[j] == j:
                spf[j] = i

def is_odd_power(n):
    while n > 1:
        p = spf[n]
        cnt = 0
        while n % p == 0:
            n //= p
            cnt += 1
        if cnt % 2 == 0:
            return False
    return True

m = int(input())
l, r = map(int, input().split())

sequence = []

for x in range(l, r + 1):
    if is_odd_power(x):
        sequence.append(x)
        if len(sequence) == m:
            print(*sequence)
            break
    else:
        sequence.clear()
else:
    print(-1)