import sys

def main():
    print("Введите m:")
    m = int(sys.stdin.readline().strip())

    print("Введите l и r через пробел:")
    l, r = map(int, sys.stdin.readline().strip().split())

    n = r

    spf = [0] * (n + 1)
    primes = []


    for i in range(2, n + 1):
        if spf[i] == 0:
            spf[i] = i
            primes.append(i)
        for p in primes:
            if p > spf[i] or i * p > n:
                break
            spf[i * p] = p


    def is_odd_power(x):
        last_p = 0
        cnt = 0
        while x > 1:
            p = spf[x]
            if p != last_p:
                if last_p != 0 and cnt % 2 == 0:
                    return False
                last_p = p
                cnt = 0
            x //= p
            cnt += 1

        return cnt % 2 == 1


    consecutive = 0
    start = -1

    for i in range(l, r + 1):
        if is_odd_power(i):
            consecutive += 1
            if consecutive >= m:
                start = i - m + 1
                break
        else:
            consecutive = 0


    print("\nРезультат:")
    if start == -1:
        print(-1)
    else:
        result = ' '.join(str(start + j) for j in range(m))
        print(result)


if __name__ == "__main__":
    main()