import sys

def main():
    print("Введите m:")
    m_line = sys.stdin.readline()
    if not m_line:
        return
    m = int(m_line.strip())

    print("Введите l и r через пробел:")
    lr_line = sys.stdin.readline()
    if not lr_line:
        return
    l, r = map(int, lr_line.strip().split())

    # Массив: good[i] = True, если число i нечётно-степенное
    good = [True] * (r + 1)
    good[0] = good[1] = False

    # Отмечаем числа, которые делятся на квадрат простого
    for p in range(2, int(r ** 0.5) + 1):
        square = p * p
        if square > r:
            break
        # Отмечаем все числа, кратные square
        for j in range(square, r + 1, square):
            good[j] = False

    # Ищем последовательность длины m
    count = 0
    start = -1

    for i in range(l, r + 1):
        if good[i]:
            count += 1
            if count >= m:
                start = i - m + 1
                break
        else:
            count = 0

    print("\nРезультат:")
    if start == -1:
        print(-1)
    else:
        result = ' '.join(str(start + j) for j in range(m))
        print(result)


if __name__ == "__main__":
    main()