import sys

def normalize_line(A, B, C):
    if A < 0 or (A == 0 and B < 0):
        A, B, C = -A, -B, -C

    def gcd(a, b):
        while b:
            a, b = b, a % b
        return abs(a)
    g = gcd(gcd(abs(A), abs(B)), abs(C))
    if g != 0:
        A //= g
        B //= g
        C //= g
    return (A, B, C)

def line_through_points(x1, y1, x2, y2):
    A = y1 - y2
    B = x2 - x1
    C = x1 * y2 - x2 * y1
    return normalize_line(A, B, C)

def touches_rect(line, rect):
    A, B, C = line
    x1, y1, x2, y2 = rect
    vals = [
        A * x1 + B * y1 + C,
        A * x2 + B * y1 + C,
        A * x1 + B * y2 + C,
        A * x2 + B * y2 + C
    ]
    minv = min(vals)
    maxv = max(vals)
    return minv <= 0 <= maxv

def check_candidate(line, rects):
    for rect in rects:
        if not touches_rect(line, rect):
            return False
    return True

def solve_one_set(rects):
    n = len(rects)
    if n == 1:
        return True


    min_right = min(r[2] for r in rects)
    max_left = max(r[0] for r in rects)
    if max_left <= min_right:
        return True

    min_top = min(r[3] for r in rects)
    max_bottom = max(r[1] for r in rects)
    if max_bottom <= min_top:
        return True


    for x in (max_left, min_right):
        if check_candidate((1, 0, -x), rects):
            return True
    for y in (max_bottom, min_top):
        if check_candidate((0, 1, -y), rects):
            return True


    verts = []
    for i, (x1, y1, x2, y2) in enumerate(rects):
        verts.append((x1, y1, i))
        verts.append((x1, y2, i))
        verts.append((x2, y1, i))
        verts.append((x2, y2, i))

    candidates_set = set()
    for i in range(len(verts)):
        x1, y1, idx1 = verts[i]
        for j in range(i + 1, len(verts)):
            x2, y2, idx2 = verts[j]
            if idx1 == idx2:
                continue
            if (x1, y1) == (x2, y2):
                continue
            line = line_through_points(x1, y1, x2, y2)
            if line not in candidates_set:
                candidates_set.add(line)
                if check_candidate(line, rects):
                    return True

    return False

def main():
    input_data = sys.stdin.read().strip().split()
    if not input_data:
        return
    t = int(input_data[0])
    pos = 1
    out_lines = []
    for _ in range(t):
        n = int(input_data[pos])
        pos += 1
        rects = []
        for __ in range(n):
            x1 = int(input_data[pos])
            y1 = int(input_data[pos + 1])
            x2 = int(input_data[pos + 2])
            y2 = int(input_data[pos + 3])
            pos += 4
            rects.append((x1, y1, x2, y2))
        if solve_one_set(rects):
            out_lines.append("Yes")
        else:
            out_lines.append("No")
    sys.stdout.write("\n".join(out_lines))

if __name__ == "__main__":
    main()