import sys


def main():
    data = sys.stdin.read().split()
    m = int(data[0])
    l = int(data[1])
    r = int(data[2])

    # Создаем массив для отметки чисел
    good = [True] * (r + 1)

    # Решето: отмечаем числа, которые не являются нечётно-степенными
    for p in range(2, r + 1):
        if p * p > r:
            break
        # Для каждого простого p отмечаем все числа вида p^(2k) * t
        p2 = p * p
        for num in range(p2, r + 1, p2):
            good[num] = False

    # Ищем последовательность из m подряд идущих хороших чисел
    count = 0
    for num in range(l, r + 1):
        if good[num]:
            count += 1
            if count >= m:
                # Нашли последовательность
                start = num - m + 1
                result = ' '.join(str(x) for x in range(start, start + m))
                print(result)
                return
        else:
            count = 0

    print(-1)


if __name__ == "__main__":
    main()