import sys


def readints():
    return list(map(int, sys.stdin.readline().split()))


def point_on_rect(px, py, x1, y1, x2, y2):
    if px < x1 or px > x2 or py < y1 or py > y2:
        return False
    return px == x1 or px == x2 or py == y1 or py == y2


def line_touches_all(rects, p1, p2):
    x1, y1 = p1
    x2, y2 = p2
    dx = x2 - x1
    dy = y2 - y1

    for (rx1, ry1, rx2, ry2) in rects:
        touched = False
        for px, py in [(rx1, ry1), (rx1, ry2), (rx2, ry1), (rx2, ry2)]:
            if dx * (py - y1) == dy * (px - x1):
                touched = True
                break
        if touched:
            continue

        if dy != 0:
            x_inter = x1 + (ry1 - y1) * dx / dy
            if rx1 <= x_inter <= rx2:
                touched = True
        if not touched and dy != 0:
            x_inter = x1 + (ry2 - y1) * dx / dy
            if rx1 <= x_inter <= rx2:
                touched = True

        if dx != 0 and not touched:
            y_inter = y1 + (rx1 - x1) * dy / dx
            if ry1 <= y_inter <= ry2:
                touched = True
        if dx != 0 and not touched:
            y_inter = y1 + (rx2 - x1) * dy / dx
            if ry1 <= y_inter <= ry2:
                touched = True

        if not touched:
            return False
    return True


def solve_case(rects):
    if len(rects) == 1:
        return True

    points = set()
    for x1, y1, x2, y2 in rects:
        points.add((x1, y1))
        points.add((x1, y2))
        points.add((x2, y1))
        points.add((x2, y2))

    sorted_x = sorted(points, key=lambda p: p[0])
    sorted_y = sorted(points, key=lambda p: p[1])
    candidate_points = (
            sorted_x[:2] + sorted_x[-2:] +
            sorted_y[:2] + sorted_y[-2:]
    )
    candidate_points = list(set(candidate_points))

    for i in range(len(candidate_points)):
        for j in range(i + 1, len(candidate_points)):
            p1 = candidate_points[i]
            p2 = candidate_points[j]
            if line_touches_all(rects, p1, p2):
                return True
    return False


def main():
    T = int(sys.stdin.readline())
    for _ in range(T):
        n = int(sys.stdin.readline())
        rects = []
        for _ in range(n):
            x1, y1, x2, y2 = readints()
            rects.append((x1, y1, x2, y2))

        if solve_case(rects):
            print("Yes")
        else:
            print("No")


if __name__ == "__main__":
    main()
