import sys


def precompute_non_odd_power(max_n):
    # Для каждого числа храним его "квадратную часть": произведение p^(2k), где 2k — максимальная чётная степень p, на которую делится число
    square_part = [1] * (max_n + 1)

    for p in range(2, max_n + 1):
        if square_part[p] == 1:  # p — простое
            # Проходим по всем степеням p: p^2, p^4, p^6, ...
            p_square = p * p
            while p_square <= max_n:
                for multiple in range(p_square, max_n + 1, p_square):
                    square_part[multiple] *= p_square
                p_square *= p * p  # переходим к p^4, p^6 и т.д.

    # Число нечётно-степенное, если его "квадратная часть" равна 1 (нет простых в чётных степенях)
    is_non_odd_power = [square_part[i] == 1 for i in range(max_n + 1)]
    is_non_odd_power[0] = False  # по условию 0 не считается
    return is_non_odd_power


def main():
    m = int(sys.stdin.readline())
    l, r = map(int, sys.stdin.readline().split())

    MAX_N = 10 ** 6
    is_non_odd_power = precompute_non_odd_power(MAX_N)

    count = 0
    start = -1

    for i in range(l, r + 1):
        if is_non_odd_power[i]:
            count += 1
            if count == m:
                start = i - m + 1
                break
        else:
            count = 0

    if start != -1:
        print(' '.join(map(str, range(start, start + m))))
    else:
        print(-1)


if __name__ == '__main__':
    main()
