import sys

def precompute_non_odd_power(max_n):
    is_non_odd_power = [True] * (max_n + 1)
    is_non_odd_power[0] = False
    is_non_odd_power[1] = True

    for p in range(2, max_n + 1):
        if is_non_odd_power[p]:
            power = p * p
            while power <= max_n:
                for multiple in range(power, max_n + 1, power):
                    is_non_odd_power[multiple] = False
                power *= p * p
    return is_non_odd_power

def main():
    m = int(sys.stdin.readline())
    l, r = map(int, sys.stdin.readline().split())

    MAX_N = 10**6
    is_non_odd_power = precompute_non_odd_power(MAX_N)

    count = 0
    start = -1

    for i in range(l, r + 1):
        if is_non_odd_power[i]:
            count += 1
            if count == m:
                start = i - m + 1
                break
        else:
            count = 0

    if start != -1:
        print(' '.join(map(str, range(start, start + m))))
    else:
        print(-1)

if __name__ == '__main__':
    main()
