import sys

def precompute_non_odd_power(max_n):
    # is_non_odd_power[i] = True, если i — нечётно-степенное
    is_non_odd_power = [True] * (max_n + 1)
    is_non_odd_power[0] = False
    is_non_odd_power[1] = True  # 1 не имеет простых множителей → считаем нечётно-степенным

    # Для каждого простого p проверяем его квадраты, четвёртые степени и т.д.
    for p in range(2, max_n + 1):
        if is_non_odd_power[p]:  # p — простое (пока не помечено)
            # Проходим по степеням p: p^2, p^4, p^6, ... (чётные степени)
            power = p * p
            while power <= max_n:
                # Все числа, делящиеся на power, имеют p в степени >=2
                # Если число делится на p^2, но не на p^3, то степень p — 2 (чётная)
                # Значит, оно не нечётно-степенное
                for multiple in range(power, max_n + 1, power):
                    is_non_odd_power[multiple] = False
                power *= p * p  # переходим к p^4, p^6 и т.д.
    return is_non_odd_power

def main():
    m = int(sys.stdin.readline())
    l, r = map(int, sys.stdin.readline().split())

    MAX_N = 10**6
    is_non_odd_power = precompute_non_odd_power(MAX_N)

    # Ищем первую последовательность из m подряд идущих нечётно-степенных чисел в [l, r]
    count = 0
    start = -1

    for i in range(l, r + 1):
        if is_non_odd_power[i]:
            count += 1
            if count == m:
                start = i - m + 1
                break
        else:
            count = 0

    if start != -1:
        result = list(range(start, start + m))
        print(' '.join(map(str, result)))
    else:
        print(-1)

if __name__ == '__main__':
    main()
