import math


def is_odd_power_number(n):
    """Проверяет, является ли число нечётно-степенным."""
    if n == 1:
        return True  # 1 не имеет простых делителей, считаем его нечётно-степенным

    temp = n
    for p in range(2, int(math.isqrt(n)) + 1):
        if temp % p == 0:
            count = 0
            while temp % p == 0:
                count += 1
                temp //= p
            if count % 2 == 0:  # если степень чётная
                return False
    # если остался простой множитель > sqrt(n)
    if temp > 1:
        # его степень равна 1 (нечётная)
        pass
    return True


def find_sequence(m, l, r):
    """Находит первую последовательность из m подряд идущих нечётно-степенных чисел на [l, r]."""
    current_count = 0
    start = -1

    for num in range(l, r + 1):
        if is_odd_power_number(num):
            current_count += 1
            if current_count == m:
                start = num - m + 1
                break
        else:
            current_count = 0

    if start == -1:
        return -1
    else:
        return list(range(start, start + m))


# Чтение входных данных
m = int(input())
l, r = map(int, input().split())

# Поиск последовательности
result = find_sequence(m, l, r)

# Вывод результата
if result == -1:
    print(-1)
else:
    print(' '.join(map(str, result)))






