n = int(input())
m = int(input())
k = int(input())

# Минимум и максимум из n и m
min_nm = min(n, m)
max_nm = max(n, m)

# Итоговые счётчики для цветов (1..k)
count = [0] * k

# Группа 1: d от 1 до min_nm (длина = d)
start_d1, end_d1 = 1, min_nm
if start_d1 <= end_d1:
    for d in range(start_d1, end_d1 + 1):
        color = (d - 1) % k
        count[color] += d

# Группа 2: d от min_nm+1 до max_nm (длина = min_nm)
start_d2, end_d2 = min_nm + 1, max_nm
if start_d2 <= end_d2:
    length = min_nm
    # Количество диагоналей в группе 2
    num_diagonals = end_d2 - start_d2 + 1
    # Для каждого цвета c посчитаем, сколько раз он встречается
    for c in range(k):
        # Первая диагональ в группе 2 с цветом c
        first_d = start_d2 + ((c - (start_d2 - 1) % k) + k) % k
        if first_d > end_d2:
            continue
        # Последняя диагональ в группе 2 с цветом c
        last_d = end_d2 - ((end_d2 - c) % k)
        if last_d < start_d2:
            continue
        # Количество диагоналей цвета c в группе 2
        num_c = (last_d - first_d) // k + 1
        count[c] += num_c * length

# Группа 3: d от max_nm+1 до n+m-1 (длина = n+m-d)
start_d3, end_d3 = max_nm + 1, n + m - 1
if start_d3 <= end_d3:
    # Для каждой диагонали d длина = n + m - d
    for d in range(start_d3, end_d3 + 1):
        length = n + m - d
        color = (d - 1) % k
        count[color] += length

# Вывод результатов (по одному числу в строке)
for c in range(k):
    print(count[c])