n = int(input())
m = int(input())
k = int(input())

# Размеры зон
min_nm = min(n, m)
max_nm = max(n, m)
total_diags = n + m - 1

# Массив для подсчёта цветов (индексация с 0)
color_count = [0] * k

# Зона роста: d от 1 до min_nm
start = 1
end = min_nm
if start <= end:
    # Для каждого цвета находим все d в [start, end] с этим цветом
    for color in range(k):
        # Первый d в зоне с этим цветом: color + 1 (т.к. color = (d-1) % k)
        first_d = color + 1
        if first_d < start:
            first_d += ((start - first_d - 1) // k + 1) * k
        if first_d > end:
            continue
        # Последний d в зоне с этим цветом
        last_d = end - ((end - first_d) % k)
        # Количество таких d
        count_d = (last_d - first_d) // k + 1
        # Сумма арифметической прогрессии: first_d, first_d + k, ..., last_d
        total_cells = (first_d + last_d) * count_d // 2
        color_count[color] += total_cells

# Зона плато: d от min_nm + 1 до max_nm
start = min_nm + 1
end = max_nm
if start <= end:
    cells_per_diag = min_nm
    for color in range(k):
        first_d = color + 1
        if first_d < start:
            first_d += ((start - first_d - 1) // k + 1) * k
        if first_d > end:
            continue
        last_d = end - ((end - first_d) % k)
        count_d = (last_d - first_d) // k + 1
        total_cells = cells_per_diag * count_d
        color_count[color] += total_cells

# Зона убывания: d от max_nm + 1 до n + m - 1
start = max_nm + 1
end = total_diags
if start <= end:
    for color in range(k):
        first_d = color + 1
        if first_d < start:
            first_d += ((start - first_d - 1) // k + 1) * k
        if first_d > end:
            continue
        last_d = end - ((end - first_d) % k)
        count_d = (last_d - first_d) // k + 1
        # cells(d) = n + m - d
        # Сумма: (n+m - first_d) + (n+m - (first_d + k)) + ... + (n+m - last_d)
        first_cells = n + m - first_d
        last_cells = n + m - last_d
        total_cells = (first_cells + last_cells) * count_d // 2
        color_count[color] += total_cells

# Выводим результаты
for cnt in color_count:
    print(cnt)
