import sys

def solve():
    try:
        # Чтение входных данных из стандартного ввода (как если бы они были введены пользователем)
        # В реальной задаче на платформе ввода-вывода, эти строки могут выглядеть иначе
        line1 = sys.stdin.readline()
        if not line1:
            return
        parts1 = line1.split()
        if not parts1:
            line1 = sys.stdin.readline()
            if not line1:
                return
            parts1 = line1.split()
            if not parts1:
                return
        
        m = int(parts1[0])
        
        if len(parts1) > 1:
            l = int(parts1[1])
            r = int(parts1[2])
        else:
            line2 = sys.stdin.readline()
            if not line2:
                return
            parts2 = line2.split()
            l = int(parts2[0])
            r = int(parts2[1])

        # Используем решето для поиска нечётно-степенных чисел (square-free) в диапазоне [l, r]
        # Будем помечать числа, которые НЕ являются нечётно-степенными
        is_not_odd_powered = [False] * (r - l + 1)
        
        # Максимальное значение r <= 10^6. Нам нужно проверять квадраты простых чисел до sqrt(r).
        max_q = int(r**0.5) + 1
        
        # Решето Эратосфена для нахождения простых чисел до sqrt(r)
        is_p = [True] * max_q
        is_p[0] = is_p[1] = False
        primes = []
        for p in range(2, max_q):
            if is_p[p]:
                primes.append(p)
                for i in range(p*p, max_q, p):
                    is_p[i] = False
        
        # Модифицированное решето для нечётно-степенных чисел
        for p in primes:
            # Находим первый делитель p*p в диапазоне [l, r]
            p_squared = p * p
            # Если p*p больше r, дальше можно не идти
            if p_squared > r:
                break
            
            # Находим первое число в диапазоне [l, r], делящееся на p*p
            start = (l + p_squared - 1) // p_squared * p_squared
            
            # Помечаем все числа, делящиеся на p*p, как не нечётно-степенные
            for i in range(start, r + 1, p_squared):
                is_not_odd_powered[i - l] = True

        # Поиск первой последовательности из m подряд идущих нечётно-степенных чисел
        count = 0
        for i in range(r - l + 1):
            if not is_not_odd_powered[i]:
                count += 1
                if count >= m:
                    # Найдена последовательность
                    start_num = l + i - m + 1
                    result = [str(num) for num in range(start_num, start_num + m)]
                    print(" ".join(result))
                    return
            else:
                count = 0
        
        # Если последовательность не найдена
        print("-1")

    except EOFError:
        pass
    except ValueError:
        pass

if __name__ == "__main__":
    solve()
